/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.datagen;

import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.datagen.BaseBlockStateProvider;
import mcjty.rftoolsutility.modules.crafter.CrafterModule;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStates
extends BaseBlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "rftoolsutility", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.variantBlock((Block)SpawnerModule.MATTER_BEAMER.get(), blockState -> {
            if (((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                return this.models().cubeAll("matter_beamer_on", this.modLoc("block/machinebeamer"));
            }
            return this.models().cubeAll("matter_beamer_off", this.modLoc("block/machinebeameroff"));
        });
        this.orientedBlock((Block)SpawnerModule.SPAWNER.get(), this.frontBasedModel("spawner", this.modLoc("block/machinespawner")));
        this.orientedBlock((Block)CrafterModule.CRAFTER1.get(), this.frontBasedModel("crafter1", this.modLoc("block/machinecrafter1")));
        this.orientedBlock((Block)CrafterModule.CRAFTER2.get(), this.frontBasedModel("crafter2", this.modLoc("block/machinecrafter2")));
        this.orientedBlock((Block)CrafterModule.CRAFTER3.get(), this.frontBasedModel("crafter3", this.modLoc("block/machinecrafter3")));
        this.orientedBlock((Block)TeleporterModule.DESTINATION_ANALYZER.get(), this.frontBasedModel("destination_analyzer", this.modLoc("block/machinedestinationanalyzer")));
        this.orientedBlock((Block)TeleporterModule.DIALING_DEVICE.get(), this.frontBasedModel("dialing_device", this.modLoc("block/machinedialingdevice")));
        this.orientedBlock((Block)TeleporterModule.MATTER_BOOSTER.get(), this.frontBasedModel("matter_booster", this.modLoc("block/machinematterbooster")));
        this.simpleBlock((Block)TeleporterModule.MATTER_RECEIVER.get(), this.topBasedModel("matter_receiver", this.modLoc("block/machinereceiver")));
        this.simpleBlock((Block)TeleporterModule.MATTER_TRANSMITTER.get(), this.topBasedModel("matter_transmitter", this.modLoc("block/machinetransmitter")));
        this.logicSlabBlock((LogicSlabBlock)TeleporterModule.SIMPLE_DIALER.get(), "simple_dialer", this.modLoc("block/machinesimpledialer"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.ANALOG.get(), "analog", this.modLoc("block/logic/machineanalogtop"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.COUNTER.get(), "counter", this.modLoc("block/logic/machinecountertop"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.DIGIT.get(), "digit", this.modLoc("block/logic/machineoutput"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.INVCHECKER.get(), "invchecker", this.modLoc("block/logic/machineinvchecker"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.SENSOR.get(), "sensor", this.modLoc("block/logic/machinesensor"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.SEQUENCER.get(), "sequencer", this.modLoc("block/logic/machinesequencertop"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.LOGIC.get(), "logic", this.modLoc("block/logic/machinelogictop"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.TIMER.get(), "timer", this.modLoc("block/logic/machinetimertop"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.WIRE.get(), "wire", this.modLoc("block/logic/machinewiretop"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.REDSTONE_RECEIVER.get(), "redstone_receiver", this.modLoc("block/logic/machineredstonereceiver"));
        this.logicSlabBlock((LogicSlabBlock)LogicBlockModule.REDSTONE_TRANSMITTER.get(), "redstone_transmitter", this.modLoc("block/logic/machineredstonetransmitter"));
        ModelFile screen = this.screenModel("screen", this.modLoc("block/screenframe_icon"));
        this.orientedBlock((Block)ScreenModule.SCREEN.get(), screen);
        this.orientedBlock((Block)ScreenModule.SCREEN_HIT.get(), screen);
        this.orientedBlock((Block)ScreenModule.CREATIVE_SCREEN.get(), this.screenModel("creative_screen", this.modLoc("block/creative_screenframe_icon")));
        this.orientedBlock((Block)ScreenModule.SCREEN_CONTROLLER.get(), this.frontBasedModel("screen_controller", this.modLoc("block/machinescreencontroller")));
        this.frontBasedModel("tank_inventory", this.modLoc("block/tank0"));
        this.createEnvController();
    }

    public ModelFile screenModel(String modelName, ResourceLocation texture) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/" + modelName)).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block")));
        ((BlockModelBuilder)((BlockModelBuilder)model.element().from(0.0f, 0.0f, 13.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).cullface(Direction.DOWN).texture("#side").end().face(Direction.UP).cullface(Direction.UP).texture("#side").end().face(Direction.EAST).cullface(Direction.EAST).texture("#side").end().face(Direction.WEST).cullface(Direction.WEST).texture("#side").end().face(Direction.NORTH).texture("#front").end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#side").end().end()).texture("side", new ResourceLocation("rftoolsbase", "block/base/machineside"))).texture("front", texture);
        return model;
    }

    private void createEnvController() {
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder("block/environmental_controller");
        model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, faceBuilder) -> {
            if (direction == Direction.UP) {
                faceBuilder.texture("#top");
            } else if (direction == Direction.DOWN) {
                faceBuilder.texture("#bottom");
            } else {
                faceBuilder.texture("#side");
            }
        }).end();
        model.element().from(0.0f, 3.0f, 0.0f).to(16.0f, 3.0f, 16.0f).face(Direction.UP).texture("#bottom").end();
        model.element().from(0.0f, 16.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#top").end();
        model.element().from(0.0f, 0.0f, 16.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).texture("#side").end();
        model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.0f).face(Direction.SOUTH).texture("#side").end();
        model.element().from(16.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.WEST).texture("#side").end();
        model.element().from(0.0f, 0.0f, 0.0f).to(0.0f, 16.0f, 16.0f).face(Direction.EAST).texture("#side").end();
        ((BlockModelBuilder)((BlockModelBuilder)model.texture("top", new ResourceLocation("rftoolsbase", "block/base/machinetop"))).texture("side", this.modLoc("block/machineenvironmentalcontroller"))).texture("bottom", new ResourceLocation("rftoolsbase", "block/base/machinebottom"));
        MultiPartBlockStateBuilder bld = this.getMultipartBuilder((Block)EnvironmentalModule.ENVIRONENTAL_CONTROLLER.get());
        bld.part().modelFile((ModelFile)model).addModel();
    }
}

